export default class GameManager extends BaseModule
{
	constructor()
	{
	    super('gameMan');
	}

	initialize(idData, shellController)
	{
		// Call super method
		super.initialize(idData, shellController);

		// Add buttons click listeners
		document.getElementById('gm-usersBt').addEventListener('click', () => this._onUserCountReqClick(false));
		document.getElementById('gm-playersBt').addEventListener('click', () => this._onUserCountReqClick(true));
		document.getElementById('gm-statsBt').addEventListener('click', () => this._onStatsReqClick());
	}

	destroy()
	{
		// Call super method
		super.destroy();
	}

	onExtensionCommand(cmd, data)
	{
		// Clear output area
		document.getElementById('gm-outputArea').innerHTML = '';

		// Handle response to "userCount" request
		if (cmd == 'userCount')
		{
			const playersOnly = data.getBool('playersOnly');
			const count = data.getInt('value');

			document.getElementById('gm-outputArea').innerHTML = `Total ${playersOnly ? 'players' : 'users'}: ${count}`;
		}

		// Handle response to "stats" request
		else if (cmd == 'stats')
		{
			const spellStats = data.getSFSObject('spells');
			const spells = spellStats.getKeysArray();

			for (let spell of spells)
				document.getElementById('gm-outputArea').innerHTML += `${spell}: ${spellStats.getInt(spell)}<br>`;
		}

		this.shellCtrl.showConfirmWarning("test message", this)
	}

	_onUserCountReqClick(playersOnly)
	{
		const params = new SFS2X.SFSObject();
		params.putBool('playersOnly', playersOnly);

		this.sendExtensionRequest('userCount', params);
	}

	_onStatsReqClick()
	{
		this.sendExtensionRequest('stats');
	}
}
