package my.namespace;

import com.smartfoxserver.v2.admin.handlers.requests.BaseAdminModuleReqHandler;
import com.smartfoxserver.v2.annotations.Instantiation;
import com.smartfoxserver.v2.annotations.MultiHandler;
import com.smartfoxserver.v2.annotations.Instantiation.InstantiationMode;
import com.smartfoxserver.v2.entities.Room;
import com.smartfoxserver.v2.entities.User;
import com.smartfoxserver.v2.entities.Zone;
import com.smartfoxserver.v2.entities.data.ISFSObject;
import com.smartfoxserver.v2.entities.data.SFSObject;
import com.smartfoxserver.v2.extensions.ISFSExtension;
import com.smartfoxserver.v2.extensions.SFSExtension;

@MultiHandler
@Instantiation(InstantiationMode.SINGLE_INSTANCE)
public class GameManagerReqHandler extends BaseAdminModuleReqHandler
{
	public static final String MODULE_ID = "GameManager";
	private static final String COMMANDS_PREFIX = "gameMan";

	public GameManagerReqHandler()
	{
		super(COMMANDS_PREFIX, MODULE_ID);
	}

	@Override
	protected void handleAdminRequest(User sender, ISFSObject params)
	{
		String cmd = params.getUtfString(SFSExtension.MULTIHANDLER_REQUEST_ID);
		
		if (cmd.equals("userCount"))
		{
			// Retrieve flag sent by the client
			boolean playersOnly = params.getBool("playersOnly");
			
			// Retrieve Zone
			Zone myZone = sfs.getZoneManager().getZoneByName("MyGame");
			
			// Count users
			int count = 0;
			
			if (!playersOnly)
				count = myZone.getUserCount();
			else
			{
				for (Room room : myZone.getRoomList()) {
					count += room.getPlayersList().size();
				}
			}
			
			// Send response back to client
			ISFSObject outParams = new SFSObject();
			outParams.putInt("value", count);
			outParams.putBool("playersOnly", playersOnly);
			
			sendResponse("userCount", outParams, sender);
		}
		
		else if (cmd.equals("stats"))
		{
			// Get a reference to the Zone Extension
			ISFSExtension ext = sfs.getZoneManager().getZoneByName("MyGame").getExtension();
			
			// Extract stats about "spells" from Extension
			ISFSObject spellsObj = (ISFSObject) ext.handleInternalMessage("spells", null);
			
			// Send response back to client
			ISFSObject outParams = new SFSObject();
			outParams.putSFSObject("spells", spellsObj);
			//outParams.putSFSObject("others", otherObj); // Other stats collected by the Extension
			
			sendResponse("stats", outParams, sender);
		}
	}
}
